/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.FloatBufferWrapper;
import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineArrayRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.PointArrayRetained;
import javax.media.j3d.QuadArrayRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArrayRetained;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;

abstract class IndexedGeometryArrayRetained
extends GeometryArrayRetained {
    int[] indexCoord;
    int[] indexColor;
    int[] indexNormal;
    int[][] indexTexCoord;
    int[][] indexVertexAttr;
    int indexCount = 0;
    int initialIndexIndex = 0;
    int validIndexCount = 0;
    int[] compileIndexCount;
    int[] compileIndexOffset;
    int maxCoordIndex = 0;
    int maxColorIndex = 0;
    int maxNormalIndex = 0;
    int[] maxTexCoordIndices = null;
    int[] maxVertexAttrIndices = null;

    IndexedGeometryArrayRetained() {
    }

    void createIndexedGeometryArrayData(int n2) {
        int n3;
        boolean bl;
        this.indexCount = n2;
        this.validIndexCount = n2;
        boolean bl2 = bl = (this.vertexFormat & 0x200) == 0;
        if ((this.vertexFormat & 1) != 0 && (this.vertexFormat & 0x2000) == 0) {
            this.indexCoord = new int[n2];
        }
        if ((this.vertexFormat & 2) != 0 && bl) {
            this.indexNormal = new int[n2];
        }
        if ((this.vertexFormat & 4) != 0 && bl) {
            this.indexColor = new int[n2];
        }
        if ((this.vertexFormat & 0x460) != 0) {
            this.indexTexCoord = new int[this.texCoordSetCount][];
            if (bl) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.indexTexCoord[n3] = new int[n2];
                }
            }
            this.maxTexCoordIndices = new int[this.texCoordSetCount];
        }
        if ((this.vertexFormat & 0x1000) != 0) {
            this.indexVertexAttr = new int[this.vertexAttrCount][];
            if (bl) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.indexVertexAttr[n3] = new int[n2];
                }
            }
            this.maxVertexAttrIndices = new int[this.vertexAttrCount];
        }
    }

    GeometryArrayRetained cloneNonIndexedGeometry() {
        GeometryArrayRetained geometryArrayRetained = null;
        switch (this.geoType) {
            case 11: {
                geometryArrayRetained = new LineArrayRetained();
                break;
            }
            case 10: {
                geometryArrayRetained = new PointArrayRetained();
                break;
            }
            case 8: {
                geometryArrayRetained = new QuadArrayRetained();
                break;
            }
            case 9: {
                geometryArrayRetained = new TriangleArrayRetained();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        geometryArrayRetained.createGeometryArrayData(this.validIndexCount, this.vertexFormat & 0xFFFFF67F, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes);
        geometryArrayRetained.cloneSourceArray = this;
        geometryArrayRetained.unIndexify(this);
        return geometryArrayRetained;
    }

    int getIndexCount() {
        return this.indexCount;
    }

    void doErrorCheck(int n2) {
        this.doCoordCheck(n2);
        if ((this.vertexFormat & 0x200) != 0) {
            int n3;
            if ((this.vertexFormat & 4) != 0) {
                this.doColorCheck(n2);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.doTexCoordCheck(n2, n3);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.doVertexAttrCheck(n2, n3);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.doNormalCheck(n2);
            }
        }
    }

    void doCoordCheck(int n2) {
        block20: {
            block22: {
                block21: {
                    block19: {
                        if ((this.vertexFormat & 0x80) != 0) break block19;
                        if (n2 >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    if ((this.vertexFormat & 0x800) == 0) break block21;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0xF) {
                            case 1: {
                                if (this.floatBufferRefCoords == null || 3 * n2 < this.floatBufferRefCoords.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                            }
                            case 2: {
                                if (this.doubleBufferRefCoords == null || 3 * n2 < this.doubleBufferRefCoords.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n2 >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                    }
                    break block20;
                }
                if ((this.vertexFormat & 0x100) != 0) break block22;
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatRefCoords != null && 3 * n2 >= this.floatRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 2: {
                        if (this.doubleRefCoords != null && 3 * n2 >= this.doubleRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 4: {
                        if (this.p3fRefCoords != null && n2 >= this.p3fRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 8: {
                        if (this.p3dRefCoords != null && n2 >= this.p3dRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                }
                break block20;
            }
            if (this.interLeavedVertexData != null && this.stride * n2 >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
            }
        }
    }

    void doColorCheck(int n2) {
        block25: {
            block27: {
                int n3;
                block26: {
                    block24: {
                        if ((this.vertexFormat & 4) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block24;
                        if (n2 >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    n3 = this.getColorStride();
                    if ((this.vertexFormat & 0x800) == 0) break block26;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0x3F0) {
                            case 16: {
                                if (this.floatBufferRefColors == null || n3 * n2 < this.floatBufferRefColors.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                            }
                            case 32: {
                                if (this.byteBufferRefColors == null || n3 * n2 < this.byteBufferRefColors.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n2 >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                    }
                    break block25;
                }
                if ((this.vertexFormat & 0x100) != 0) break block27;
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (this.floatRefColors != null && n3 * n2 >= this.floatRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 32: {
                        if (this.byteRefColors != null && n3 * n2 >= this.byteRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 64: {
                        if (this.c3fRefColors != null && n2 >= this.c3fRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 128: {
                        if (this.c4fRefColors != null && n2 >= this.c4fRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 256: {
                        if (this.c3bRefColors != null && n2 >= this.c3bRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 512: {
                        if (this.c4bRefColors != null && n2 >= this.c4bRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                }
                break block25;
            }
            if (this.interLeavedVertexData != null && this.stride * n2 >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
            }
        }
    }

    void doNormalCheck(int n2) {
        block16: {
            block18: {
                block17: {
                    block15: {
                        if ((this.vertexFormat & 2) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block15;
                        if (n2 >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                    if ((this.vertexFormat & 0x800) == 0) break block17;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0xC00) {
                            case 1024: {
                                if (this.floatBufferRefNormals == null || 3 * n2 < this.floatBufferRefNormals.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n2 >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                    }
                    break block16;
                }
                if ((this.vertexFormat & 0x100) != 0) break block18;
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatRefNormals != null && 3 * n2 >= this.floatRefNormals.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                    case 2048: {
                        if (this.v3fRefNormals != null && n2 >= this.v3fRefNormals.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (this.interLeavedVertexData != null && this.stride * n2 >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
            }
        }
    }

    void doTexCoordCheck(int n2, int n3) {
        block18: {
            block20: {
                int n4;
                block19: {
                    block17: {
                        if ((this.vertexFormat & 0x460) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block17;
                        if (n2 >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    n4 = this.getTexStride();
                    if ((this.vertexFormat & 0x800) == 0) break block19;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0x7000) {
                            case 4096: {
                                FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n3]).getBufferImpl();
                                if (this.refTexCoords[n3] == null || n4 * n2 < floatBufferWrapper.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n2 >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                    break block18;
                }
                if ((this.vertexFormat & 0x100) != 0) break block20;
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        if (this.refTexCoords[n3] != null && n4 * n2 >= ((float[])this.refTexCoords[n3]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    case 8192: {
                        if (this.refTexCoords[n3] != null && n2 >= ((TexCoord2f[])this.refTexCoords[n3]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    case 16384: {
                        if (this.refTexCoords[n3] != null && n2 >= ((TexCoord3f[])this.refTexCoords[n3]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                }
                break block18;
            }
            if (this.interLeavedVertexData != null && this.stride * n2 >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
            }
        }
    }

    void doVertexAttrCheck(int n2, int n3) {
        if ((this.vertexFormat & 0x1000) == 0) {
            return;
        }
        assert ((this.vertexFormat & 0x100) == 0);
        if ((this.vertexFormat & 0x80) == 0) {
            if (n2 >= this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
            }
        } else {
            int n4 = this.vertexAttrSizes[n3];
            if ((this.vertexFormat & 0x800) != 0) {
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        if (n4 * n2 < this.floatBufferRefVertexAttrs[n3].limit()) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                    }
                }
            } else {
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        if (n4 * n2 < this.floatRefVertexAttrs[n3].length) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                    }
                }
            }
        }
    }

    final void setCoordinateIndex(int n2, int n3) {
        int n4 = this.doIndexCheck(n2, this.maxCoordIndex, this.indexCoord, n3);
        if (n4 > this.maxCoordIndex) {
            this.doErrorCheck(n4);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            int n5;
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n4;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n5 = 0; n5 < this.texCoordSetCount; ++n5) {
                    this.maxTexCoordIndices[n5] = n4;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n5 = 0; n5 < this.vertexAttrCount; ++n5) {
                    this.maxVertexAttrIndices[n5] = n4;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n4;
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x20;
        this.indexCoord[n2] = n3;
        this.maxCoordIndex = n4;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    int doIndexCheck(int n2, int n3, int[] nArray, int n4) {
        int n5 = n3;
        if (n2 < this.initialIndexIndex) {
            return n5;
        }
        if (n2 >= this.initialIndexIndex + this.validIndexCount) {
            return n5;
        }
        if (n4 < 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
        }
        if (n5 == nArray[n2]) {
            if (n4 >= n5) {
                n5 = n4;
            } else {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    if (nArray[i2] <= n5) continue;
                    n5 = nArray[i2];
                }
            }
        } else if (n4 > n5) {
            n5 = n4;
        }
        return n5;
    }

    int doIndicesCheck(int n2, int n3, int[] nArray, int[] nArray2) {
        int n4 = n3;
        boolean bl = false;
        int n5 = nArray2.length;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n5; ++i2) {
            if (n2 + i2 < this.initialIndexIndex || n2 + i2 >= this.initialIndexIndex + this.validIndexCount) continue;
            if (nArray2[i2] < 0) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
            }
            if (nArray[n2 + i2] == n3) {
                if (nArray2[i2] >= n4) {
                    n4 = nArray2[i2];
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (bl2) continue;
                bl = true;
                continue;
            }
            if (nArray2[i2] < n4) continue;
            n4 = nArray2[i2];
            bl = false;
            bl2 = true;
        }
        if (bl) {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (nArray[i3] <= n4) continue;
                n4 = nArray[i3];
            }
        }
        return n4;
    }

    final void setCoordinateIndices(int n2, int[] nArray) {
        int n3;
        int n4 = nArray.length;
        int n5 = this.doIndicesCheck(n2, this.maxCoordIndex, this.indexCoord, nArray);
        if (n5 > this.maxCoordIndex) {
            this.doErrorCheck(n5);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n5;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.maxTexCoordIndices[n3] = n5;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.maxVertexAttrIndices[n3] = n5;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n5;
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = n5;
        n3 = 0;
        int n6 = n2;
        while (n3 < n4) {
            this.indexCoord[n6] = nArray[n3];
            ++n3;
            ++n6;
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    final void setCoordIndicesRef(int[] nArray) {
        int n2 = 0;
        if (nArray != null) {
            if (nArray.length < this.initialIndexIndex + this.validIndexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray33"));
            }
            n2 = this.computeMaxIndexWithCheck(this.initialIndexIndex, this.validIndexCount, nArray);
            if (n2 > this.maxCoordIndex) {
                this.doErrorCheck(n2);
            }
        }
        if ((this.vertexFormat & 0x200) != 0) {
            int n3;
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n2;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.maxTexCoordIndices[n3] = n2;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.maxVertexAttrIndices[n3] = n2;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n2;
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = n2;
        this.indexCoord = nArray;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    final void doPostUpdaterUpdate() {
        int n2 = 0;
        if (this.indexCoord != null && (n2 = this.computeMaxIndexWithCheck(this.initialIndexIndex, this.validIndexCount, this.indexCoord)) > this.maxCoordIndex) {
            this.doErrorCheck(n2);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            int n3;
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n2;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.maxTexCoordIndices[n3] = n2;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.maxVertexAttrIndices[n3] = n2;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n2;
            }
        }
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = n2;
    }

    final void setColorIndex(int n2, int n3) {
        int n4 = this.maxColorIndex;
        n4 = this.doIndexCheck(n2, this.maxColorIndex, this.indexColor, n3);
        if (n4 > this.maxColorIndex) {
            this.doColorCheck(n4);
        }
        this.geomLock.getLock();
        this.indexColor[n2] = n3;
        this.maxColorIndex = n4;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setColorIndices(int n2, int[] nArray) {
        int n3 = nArray.length;
        int n4 = this.doIndicesCheck(n2, this.maxColorIndex, this.indexColor, nArray);
        if (n4 > this.maxColorIndex) {
            this.doColorCheck(n4);
        }
        this.geomLock.getLock();
        this.maxColorIndex = n4;
        int n5 = 0;
        int n6 = n2;
        while (n5 < n3) {
            this.indexColor[n6] = nArray[n5];
            ++n5;
            ++n6;
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setNormalIndex(int n2, int n3) {
        int n4 = this.doIndexCheck(n2, this.maxNormalIndex, this.indexNormal, n3);
        if (n4 > this.maxNormalIndex) {
            this.doNormalCheck(n4);
        }
        this.geomLock.getLock();
        this.maxNormalIndex = n4;
        this.indexNormal[n2] = n3;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setNormalIndices(int n2, int[] nArray) {
        int n3 = nArray.length;
        int n4 = this.doIndicesCheck(n2, this.maxNormalIndex, this.indexNormal, nArray);
        if (n4 > this.maxNormalIndex) {
            this.doNormalCheck(n4);
        }
        this.geomLock.getLock();
        int n5 = 0;
        int n6 = n2;
        while (n5 < n3) {
            this.indexNormal[n6] = nArray[n5];
            ++n5;
            ++n6;
        }
        this.maxNormalIndex = n4;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setTextureCoordinateIndex(int n2, int n3, int n4) {
        int[] nArray = this.indexTexCoord[n2];
        int n5 = this.doIndexCheck(n3, this.maxTexCoordIndices[n2], nArray, n4);
        if (n5 > this.maxTexCoordIndices[n2]) {
            this.doTexCoordCheck(n5, n2);
        }
        this.geomLock.getLock();
        this.maxTexCoordIndices[n2] = n5;
        nArray[n3] = n4;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setTextureCoordinateIndices(int n2, int n3, int[] nArray) {
        int n4 = nArray.length;
        int[] nArray2 = this.indexTexCoord[n2];
        int n5 = this.doIndicesCheck(n3, this.maxTexCoordIndices[n2], nArray2, nArray);
        if (n5 > this.maxTexCoordIndices[n2]) {
            this.doTexCoordCheck(n5, n2);
        }
        this.geomLock.getLock();
        this.maxTexCoordIndices[n2] = n5;
        int n6 = 0;
        int n7 = n3;
        while (n6 < n4) {
            nArray2[n7] = nArray[n6];
            ++n6;
            ++n7;
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrIndex(int n2, int n3, int n4) {
        int[] nArray = this.indexVertexAttr[n2];
        int n5 = this.doIndexCheck(n3, this.maxVertexAttrIndices[n2], nArray, n4);
        if (n5 > this.maxVertexAttrIndices[n2]) {
            this.doVertexAttrCheck(n5, n2);
        }
        this.geomLock.getLock();
        this.maxVertexAttrIndices[n2] = n5;
        nArray[n3] = n4;
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrIndices(int n2, int n3, int[] nArray) {
        int n4 = nArray.length;
        int[] nArray2 = this.indexVertexAttr[n2];
        int n5 = this.doIndicesCheck(n3, this.maxVertexAttrIndices[n2], nArray2, nArray);
        if (n5 > this.maxVertexAttrIndices[n2]) {
            this.doVertexAttrCheck(n5, n2);
        }
        this.geomLock.getLock();
        this.maxVertexAttrIndices[n2] = n5;
        int n6 = 0;
        int n7 = n3;
        while (n6 < n4) {
            nArray2[n7] = nArray[n6];
            ++n6;
            ++n7;
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(false);
        }
    }

    final int getCoordinateIndex(int n2) {
        return this.indexCoord[n2];
    }

    final void getCoordinateIndices(int n2, int[] nArray) {
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            nArray[n4] = this.indexCoord[n5];
            ++n4;
            ++n5;
        }
    }

    final int[] getCoordIndicesRef() {
        return this.indexCoord;
    }

    final int getColorIndex(int n2) {
        return this.indexColor[n2];
    }

    final void getColorIndices(int n2, int[] nArray) {
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            nArray[n4] = this.indexColor[n5];
            ++n4;
            ++n5;
        }
    }

    final int getNormalIndex(int n2) {
        return this.indexNormal[n2];
    }

    final void getNormalIndices(int n2, int[] nArray) {
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            nArray[n4] = this.indexNormal[n5];
            ++n4;
            ++n5;
        }
    }

    final int getTextureCoordinateIndex(int n2, int n3) {
        int[] nArray = this.indexTexCoord[n2];
        return nArray[n3];
    }

    final void getTextureCoordinateIndices(int n2, int n3, int[] nArray) {
        int n4 = nArray.length;
        int[] nArray2 = this.indexTexCoord[n2];
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            nArray[n5] = nArray2[n6];
            ++n5;
            ++n6;
        }
    }

    int getVertexAttrIndex(int n2, int n3) {
        int[] nArray = this.indexVertexAttr[n2];
        return nArray[n3];
    }

    void getVertexAttrIndices(int n2, int n3, int[] nArray) {
        int n4 = nArray.length;
        int[] nArray2 = this.indexVertexAttr[n2];
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            nArray[n5] = nArray2[n6];
            ++n5;
            ++n6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f2, int n2, boolean bl3) {
        boolean bl4 = false;
        if (this.mirrorGeometry != null) {
            this.mirrorGeometry.execute(canvas3D, renderAtom, bl, bl2, f2, n2, bl3);
            return;
        }
        if (this.indexCoord == null) {
            return;
        }
        if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                float[] fArray;
                int n3;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
                synchronized (indexedGeometryArrayRetained) {
                    n3 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        Object[] objectArray = this.updateAlphaInVertexData(canvas3D, n2, f2);
                        bl4 = objectArray[0] == Boolean.TRUE;
                        fArray = (float[])objectArray[1];
                        if (f2 != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f2;
                            n3 |= 4;
                        }
                    } else {
                        fArray = this.vertexData;
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n3 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
                Pipeline.getPipeline().executeIndexedGeometry(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, (this.vertexFormat & 4) != 0 ? this.vertexFormat | 0xC : this.vertexFormat, this.vertexAttrCount, this.vertexAttrSizes, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, fArray, null, n3, this.indexCoord);
            } else if ((this.vertexFormat & 0x100) != 0) {
                int n4;
                if (this.interLeavedVertexData == null) {
                    return;
                }
                float[] fArray = null;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
                synchronized (indexedGeometryArrayRetained) {
                    n4 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n2, f2);
                        bl4 = objectArray[0] == Boolean.TRUE;
                        fArray = (float[])objectArray[1];
                        if (f2 != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f2;
                            n4 |= 4;
                        }
                    } else if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n4 |= 4;
                    }
                    this.dirtyFlag = 0;
                }
                Pipeline.getPipeline().executeIndexedGeometry(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.vertexAttrCount, this.vertexAttrSizes, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.interLeavedVertexData, fArray, n4, this.indexCoord);
            } else {
                int n5;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained;
                if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                    return;
                }
                byte[] byArray = null;
                float[] fArray = null;
                if ((this.vertexType & 0xD0) != 0) {
                    indexedGeometryArrayRetained = this;
                    synchronized (indexedGeometryArrayRetained) {
                        n5 = this.dirtyFlag;
                        if (bl2 && !bl3) {
                            fArray = this.updateAlphaInFloatRefColors(canvas3D, n2, f2);
                            if (f2 != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f2;
                                n5 |= 4;
                            }
                        } else {
                            fArray = this.mirrorFloatRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n5 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else if ((this.vertexType & 0x320) != 0) {
                    indexedGeometryArrayRetained = this;
                    synchronized (indexedGeometryArrayRetained) {
                        n5 = this.dirtyFlag;
                        if (bl2 && !bl3) {
                            byArray = this.updateAlphaInByteRefColors(canvas3D, n2, f2);
                            if (f2 != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f2;
                                n5 |= 4;
                            }
                        } else {
                            byArray = this.mirrorUnsignedByteRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n5 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else {
                    n5 = this.dirtyFlag;
                }
                int n6 = 0;
                if ((this.vertexType & 5) != 0) {
                    n6 |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    n6 |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    n6 |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    n6 |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    n6 |= 0x10;
                }
                if ((this.vertexType & 0x8000) != 0) {
                    n6 |= 0x40;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    n6 |= 0x20;
                }
                Pipeline.getPipeline().executeIndexedGeometryVA(canvas3D.ctx, this, this.geoType, bl, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat | this.c4fAllocated, n6, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, fArray, byArray, this.mirrorFloatRefNormals, this.vertexAttrCount, this.vertexAttrSizes, this.mirrorFloatRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, this.texCoordStride, this.mirrorRefTexCoords, n5, this.indexCoord);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n7;
            if (this.interleavedFloatBufferImpl == null) {
                return;
            }
            float[] fArray = null;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
            synchronized (indexedGeometryArrayRetained) {
                n7 = this.dirtyFlag;
                if (bl2 && !bl3) {
                    Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n2, f2);
                    bl4 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f2 != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f2;
                        n7 |= 4;
                    }
                } else if (this.lastScreenAlpha != -1.0f) {
                    this.lastScreenAlpha = -1.0f;
                    n7 |= 4;
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().executeIndexedGeometryBuffer(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.interleavedFloatBufferImpl.getBufferAsObject(), fArray, n7, this.indexCoord);
        } else {
            int n8;
            Object object;
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            byte[] byArray = null;
            float[] fArray = null;
            if ((this.vertexType & 0x10) != 0) {
                object = this;
                synchronized (object) {
                    n8 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        fArray = this.updateAlphaInFloatRefColors(canvas3D, n2, f2);
                        if (f2 != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f2;
                            n8 |= 4;
                        }
                    } else {
                        fArray = this.mirrorFloatRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n8 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else if ((this.vertexType & 0x20) != 0) {
                object = this;
                synchronized (object) {
                    n8 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        byArray = this.updateAlphaInByteRefColors(canvas3D, n2, f2);
                        if (f2 != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f2;
                            n8 |= 4;
                        }
                    } else {
                        byArray = this.mirrorUnsignedByteRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n8 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else {
                n8 = this.dirtyFlag;
            }
            object = null;
            Object object2 = null;
            Object object3 = null;
            int n9 = 0;
            if ((this.vertexType & 1) != 0) {
                n9 |= 1;
                object = this.floatBufferRefCoords.getBufferAsObject();
            } else if ((this.vertexType & 2) != 0) {
                n9 |= 2;
                object = this.doubleBufferRefCoords.getBufferAsObject();
            }
            if ((this.vertexType & 0x10) != 0) {
                n9 |= 4;
                object2 = this.floatBufferRefColors.getBufferAsObject();
            } else if ((this.vertexType & 0x20) != 0) {
                n9 |= 8;
                object2 = this.byteBufferRefColors.getBufferAsObject();
            }
            if ((this.vertexType & 0xC00) != 0) {
                n9 |= 0x10;
                object3 = this.floatBufferRefNormals.getBufferAsObject();
            }
            if ((this.vertexType & 0x8000) != 0) {
                n9 |= 0x40;
            }
            if ((this.vertexType & 0x7000) != 0) {
                n9 |= 0x20;
            }
            Pipeline.getPipeline().executeIndexedGeometryVABuffer(canvas3D.ctx, this, this.geoType, bl, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat | this.c4fAllocated, n9, object, object2, fArray, byArray, object3, this.vertexAttrCount, this.vertexAttrSizes, this.nioFloatBufferRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, this.texCoordStride, this.refTexCoords, n8, this.indexCoord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildGA(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f2, boolean bl3, Transform3D transform3D, Transform3D transform3D2) {
        boolean bl4 = false;
        if (this.mirrorGeometry != null) {
            ((GeometryArrayRetained)this.mirrorGeometry).buildGA(canvas3D, renderAtom, bl, bl2, f2, bl3, transform3D, transform3D2);
        } else if ((this.vertexFormat & 0x80) == 0) {
            float[] fArray;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
            synchronized (indexedGeometryArrayRetained) {
                int n2 = this.dirtyFlag;
                if (bl2 && !bl3) {
                    Object[] objectArray = this.updateAlphaInVertexData(canvas3D, canvas3D.screen.screen, f2);
                    bl4 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f2 != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f2;
                        n2 |= 4;
                    }
                } else {
                    fArray = this.vertexData;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n2 |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().buildIndexedGeometry(canvas3D.ctx, this, this.geoType, bl, bl2, f2, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.vertexAttrCount, this.vertexAttrSizes, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat, fArray, this.indexCoord);
        }
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n2;
        int n3 = arrayList.size();
        int[] nArray = null;
        this.indexCount = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)arrayList.get(n2);
            this.indexCount += indexedGeometryArrayRetained.validIndexCount;
        }
        this.validIndexCount = this.indexCount;
        this.initialIndexIndex = 0;
        this.compileIndexCount = new int[n3];
        this.compileIndexOffset = new int[n3];
        this.indexCoord = new int[this.indexCount];
        int n4 = n2 = (this.vertexFormat & 0x200) == 0 ? 1 : 0;
        if (n2 != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.indexColor = new int[this.indexCount];
            }
            if ((this.vertexFormat & 2) != 0) {
                this.indexNormal = new int[this.indexCount];
            }
            if ((this.vertexFormat & 0x460) != 0) {
                this.indexTexCoord = new int[1][];
                this.indexTexCoord[0] = new int[this.indexCount];
                nArray = this.indexTexCoord[0];
            }
        }
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n7;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)arrayList.get(i2);
            this.compileIndexCount[i2] = n7 = indexedGeometryArrayRetained.validIndexCount;
            for (int i3 = 0; i3 < n7; ++i3) {
                this.indexCoord[i3 + n6] = indexedGeometryArrayRetained.indexCoord[i3 + indexedGeometryArrayRetained.initialIndexIndex] + n5;
                if (n2 == 0) continue;
                if ((this.vertexFormat & 4) != 0) {
                    this.indexColor[i3 + n6] = indexedGeometryArrayRetained.indexColor[i3 + indexedGeometryArrayRetained.initialIndexIndex] + n5;
                }
                if ((this.vertexFormat & 2) != 0) {
                    this.indexNormal[i3 + n6] = indexedGeometryArrayRetained.indexNormal[i3 + indexedGeometryArrayRetained.initialIndexIndex] + n5;
                }
                if ((this.vertexFormat & 0x460) == 0) continue;
                nArray[i3 + n6] = indexedGeometryArrayRetained.indexTexCoord[0][i3 + indexedGeometryArrayRetained.initialIndexIndex] + n5;
            }
            this.maxCoordIndex = indexedGeometryArrayRetained.maxCoordIndex + n5;
            this.compileIndexOffset[i2] = n6;
            n5 += indexedGeometryArrayRetained.vertexCount;
            n6 += n7;
        }
        super.mergeGeometryArrays(arrayList);
    }

    boolean isWriteStatic() {
        return super.isWriteStatic() && !this.source.getCapability(10) && !this.source.getCapability(12) && !this.source.getCapability(14) && !this.source.getCapability(25) && !this.source.getCapability(16);
    }

    int getIndexCount(int n2) {
        return this.compileIndexCount[n2];
    }

    int computeMaxIndex(int n2, int n3, int[] nArray) {
        int n4 = 0;
        if (nArray != null) {
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                if (nArray[i2] <= n4) continue;
                n4 = nArray[i2];
            }
        }
        return n4;
    }

    int computeMaxIndexWithCheck(int n2, int n3, int[] nArray) {
        int n4 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (nArray[i2] < 0) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
            }
            if (nArray[i2] <= n4) continue;
            n4 = nArray[i2];
        }
        return n4;
    }

    void setValidIndexCount(int n2) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray21"));
        }
        if (this.initialIndexIndex + n2 > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray22"));
        }
        if ((this.vertexFormat & 0x2000) != 0 && this.indexCoord != null && this.indexCoord.length < this.initialIndexIndex + n2) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray33"));
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        n4 = this.computeMaxIndex(this.initialIndexIndex, n2, this.indexCoord);
        this.doErrorCheck(n4);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                n5 = this.computeMaxIndex(this.initialIndexIndex, n2, this.indexColor);
                this.doColorCheck(n5);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                nArray = new int[this.texCoordSetCount];
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    nArray[n3] = this.computeMaxIndex(this.initialIndexIndex, n2, this.indexTexCoord[n3]);
                    this.doTexCoordCheck(nArray[n3], n3);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                nArray2 = new int[this.vertexAttrCount];
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    nArray2[n3] = this.computeMaxIndex(this.initialIndexIndex, n2, this.indexVertexAttr[n3]);
                    this.doVertexAttrCheck(nArray2[n3], n3);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                n6 = this.computeMaxIndex(this.initialIndexIndex, n2, this.indexNormal);
                this.doNormalCheck(n6);
            }
        }
        this.geomLock.getLock();
        this.validIndexCount = n2;
        this.maxCoordIndex = n4;
        if ((this.vertexFormat & 0x200) == 0) {
            this.maxColorIndex = n5;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.maxTexCoordIndices[n3] = nArray[n3];
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.maxVertexAttrIndices[n3] = nArray2[n3];
                }
            }
            this.maxNormalIndex = n6;
        } else {
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.maxTexCoordIndices[n3] = this.maxCoordIndex;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.maxVertexAttrIndices[n3] = this.maxCoordIndex;
                }
            }
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    void setInitialIndexIndex(int n2) {
        int n3;
        if (n2 + this.validIndexCount > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray22"));
        }
        if ((this.vertexFormat & 0x2000) != 0 && this.indexCoord != null && this.indexCoord.length < n2 + this.validIndexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray33"));
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        n4 = this.computeMaxIndex(n2, this.validIndexCount, this.indexCoord);
        this.doErrorCheck(n4);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                n5 = this.computeMaxIndex(n2, this.validIndexCount, this.indexColor);
                this.doColorCheck(n5);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                nArray = new int[this.texCoordSetCount];
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    nArray[n3] = this.computeMaxIndex(n2, this.validIndexCount, this.indexTexCoord[n3]);
                    this.doTexCoordCheck(nArray[n3], n3);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                nArray2 = new int[this.vertexAttrCount];
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    nArray2[n3] = this.computeMaxIndex(n2, this.validIndexCount, this.indexVertexAttr[n3]);
                    this.doVertexAttrCheck(nArray2[n3], n3);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                n6 = this.computeMaxIndex(n2, this.validIndexCount, this.indexNormal);
                this.doNormalCheck(n6);
            }
        }
        this.geomLock.getLock();
        this.dirtyFlag |= 0x20;
        this.initialIndexIndex = n2;
        this.maxCoordIndex = n4;
        if ((this.vertexFormat & 0x200) == 0) {
            this.maxColorIndex = n5;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.maxTexCoordIndices[n3] = nArray[n3];
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.maxVertexAttrIndices[n3] = nArray2[n3];
                }
            }
            this.maxNormalIndex = n6;
        } else {
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.maxTexCoordIndices[n3] = this.maxCoordIndex;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.maxVertexAttrIndices[n3] = this.maxCoordIndex;
                }
            }
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialIndexIndex() {
        return this.initialIndexIndex;
    }

    int getValidIndexCount() {
        return this.validIndexCount;
    }

    void handleFrequencyChange(int n2) {
        if (n2 == 10 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 4) != 0 && n2 == 12 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 2) != 0 && n2 == 14 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 0x1000) != 0 && n2 == 25 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 0x460) != 0 && n2 == 16) {
            this.setFrequencyChangeMask(n2, 1);
        } else {
            super.handleFrequencyChange(n2);
        }
    }
}

